/************************************************************************************************************\

Module Name:    AinModule.h

Description:    .

    Copyright (c) 2015, Matrox Graphics Inc. All Rights Reserved.

    BSD 2-Clause License

    Redistribution and use in source and binary forms, with or without modification, are permitted provided
    that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this list of conditions and the
       following disclaimer.

    2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and
       the following disclaimer in the documentation and/or other materials provided with the distribution.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED
    WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
    PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
    ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
    LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
    INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
    TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
    ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

\************************************************************************************************************/

#ifndef INC_AINMODULE_H
#define INC_AINMODULE_H

// -----------------------------------------------------------------------------------------------------------
//                                   I N C L U D E S   A N D   U S I N G S
// -----------------------------------------------------------------------------------------------------------

#include "Liberatus.h"
#include "CommonUtils.h"
#include "ModuleLink.h"
#include "ModuleThread.h"
#include "LAudioIn.h"

// -----------------------------------------------------------------------------------------------------------
//                                   C O N S T A N T S   A N D   T Y P E S
// -----------------------------------------------------------------------------------------------------------

/************************************************************************************************************\

Structure:      AinModule

Description:    Audio in module.

\************************************************************************************************************/
typedef struct tagAinModule
{
    LAudioIn_Handle     hAin;
    ModuleThread        oCpuThread;
    ModuleLink          oOutLink;
    MUINT32             uiTickFrequency;
    MBOOL               bInternalBufferCreated;
    LAudioFormat        eAudioFormat;
    MUINT64             uiElapsedTimeUsec;
    MUINT64             uiTotalBufferCount;
    MUINT64             uiCapturedBufferCount;
    MBOOL               bSourceParamsValid;
    MUINT32             uiFramesPerBuffer;
    MUINT32             uiBufferSize;
    MBOOL               bFailSafe;
    MCHAR8              szModuleName[16];

} AinModule;

#define AinModule_Construct {   /*.hAin                     =*/ MNULL,                  \
                                /*.oCpuThread               =*/ ModuleThread_Construct, \
                                /*.oOutLink                 =*/ ModuleLink_Construct,   \
                                /*.uiTickFrequency          =*/ 0,                      \
                                /*.bInternalBufferCreated   =*/ MFALSE,                 \
                                /*.eAudioFormat             =*/ LAudioFormat_INVALID,   \
                                /*.uiElapsedTimeUsec        =*/ 0,                      \
                                /*.uiTotalBufferCount       =*/ 0,                      \
                                /*.uiCapturedBufferCount    =*/ 0,                      \
                                /*.bSourceParamsValid       =*/ MFALSE,                 \
                                /*.uiFramesPerBuffer        =*/ 0,                      \
                                /*.uiBufferSize             =*/ 0,                      \
                                /*.bFailSafe                =*/ MFALSE,                 \
                                /*.szModuleName             =*/ ""}

// -----------------------------------------------------------------------------------------------------------
//                  G L O B A L   V A R I A B L E / F U N C T I O N   R E F E R E N C E S
// -----------------------------------------------------------------------------------------------------------

LStatus AinMod_Init(
            AinModule*          poAinMod,
            LDevice_Handle      hDevice,
            MUINT32             uiAinIndex,
            MUINT32             uiBufferCount,
            MUINT32             uiFramesPerBuffer);

void    AinMod_Cleanup(
            AinModule*      poAinMod);

LStatus AinMod_GetSourceParams(
            AinModule*      poAinMod);

LStatus AinMod_Start(
            AinModule*      poAinMod);

void    AinMod_Stop(
            AinModule*      poAinMod);

// -----------------------------------------------------------------------------------------------------------
//                                 I N L I N E S   D E F I N I T I O N S
// -----------------------------------------------------------------------------------------------------------

#endif // INC_AINMODULE_H
